//******************************************************************************
//
// The Elements (Panel and Controls) that can be presented by Gadgeteer
//
// 2016/4/12 -- Copyright 2016 Peter Goodeve
//
//******************************************************************************

#ifndef ELEMENT_H
#define ELEMENT_H

enum PosMode {DEFAULT, RIGHT, BELOW, RIGHT_TOP, BELOW_LEFT};

enum YamlMode {NONE, SCALAR, MAP_KEY, MAP_VALUE, SEQUENCE, NO_POP};

enum ElemType {UNSPEC, PANEL, TEXTCTRL_ELEM, MENU_ELEM, LABEL_ELEM,
				BUTTON_ELEM, CHECKBOX_ELEM, SLIDER_ELEM /*...etc, later, probably */};

enum KeyID {	// must match Keys[] in ReadYaml.cpp
        PANELPOS,
        TITLE,
        CANCEL,
        DONE,
        WIDTH,
        HEIGHT,
        POS,
        LABEL,
        INIT,
        DIV,
        MIN,
        MAX,
        ITEMS,
        TEXTCONTROL,
        MENU,
        BUTTON,
        CHECKBOX,
        SLIDER,
        INVALID
};


struct Element {
	Element *parent;
	ElemType eltype;
	YamlMode currmode, prevmode;
	PosMode posmode;
	int32 xoffset, yoffset, width, height;
	char * label;	// instances... also Panel title
	class BView *widget;
	
	Element(ElemType etype, Element *Parent=NULL);
	virtual bool AddPair(unsigned char *key, unsigned char *value);
	virtual Element *AddKey(unsigned char *key);
	bool getPos(char *pstr);
};


struct PanelElem : Element {
	WMPanel *panel;
	BList controls;
	char *cancel, *done;
	BPoint panelPos;
	float divider;	// for TextControl only at the moment
	int32 min, max;	// for Slider only
	
	PanelElem();
	bool AddPair(unsigned char *key, unsigned char *value);
	Element *AddKey(unsigned char *key);
	Element *AddElem(unsigned char *key);
	bool getPanelPos(char *pstr);
};


struct TextCtrlElem : Element {
	char * initstr;
	float divider;
	TextCtrlElem(Element *Parent=NULL);
	bool AddPair(unsigned char *key, unsigned char *value);
};


struct MenuElem : Element {
	BList items;
	int32 marked;
	MenuElem(Element *Parent=NULL);
	bool AddPair(unsigned char *key, unsigned char *value);
};

struct LabelElem : Element {
	LabelElem(Element *Parent=NULL);
};

struct ButtonElem : Element {
	bool state, close;
	ButtonElem(Element *Parent=NULL);
	bool AddPair(unsigned char *key, unsigned char *value);
};

struct CheckBoxElem : Element {
	bool state;
	CheckBoxElem(Element *Parent=NULL);
	bool AddPair(unsigned char *key, unsigned char *value);
};

struct SliderElem : Element {
	int32 min, max, init;
	SliderElem(Element *Parent=NULL);
	bool AddPair(unsigned char *key, unsigned char *value);
};

#endif // ELEMENT_H
