//******************************************************************************
//
// Gadgeteer: Main.cpp
//
// Reads the command-line and builds a YAML string
// then passes this to parseYAML in ReadYaml.
//
// 2016/3/24 -- Copyright 2016 Peter Goodeve
//
//******************************************************************************

#include <stdio.h>
#include <unistd.h>
#include <Application.h>
#include <String.h>
#include <File.h>

extern bool
parseYAML(const unsigned char *yamlstr, int32 yamlen);
 
class App : public BApplication {
public:
	BString yaml_input;
	App() : BApplication("application/x-vnd.pjg-gadgeteer")
	{
	}

	virtual void ReadyToRun()
	{
		int res = parseYAML((const unsigned char *)yaml_input.String(), yaml_input.Length());
		if (!res) Quit();
	}

};

#define BUFSIZE 500

int main(int argc, char *argv[])
{
	int help = 0;
	int k;
	bool in_yaml = false;

	App app;
	BFile infile;
	char inbuf[BUFSIZE];

	/* Analyze command line options and arguments. */

	for (k = 1; k < argc; k ++)
	{
		if (argv[k][0] == '-') {
			if (!in_yaml && (strcmp(argv[k], "-h") == 0
					|| strcmp(argv[k], "--help") == 0)) {
				help = 1;
			}

			else if (argv[k][1] == 'f') {
				char *filename;
				int32 bytes;
				if (argv[k][2]) filename = argv[k]+2;
				else if (k < argc) filename= argv[++k];
				if (infile.SetTo(filename, B_READ_ONLY) !=B_OK) {
					fprintf(stderr, "Couldn't open %s\n", filename);
					return -1;
				}
				while ((bytes = infile.Read((void *)inbuf, BUFSIZE)) > 0) {
					app.yaml_input.Append(inbuf, bytes);
				}
			}

			else if (in_yaml)	// assume it's a parameter
				app.yaml_input << argv[k] << " ";
			else {
				fprintf(stderr, "Unrecognized option: %s\n"
					"Try `%s --help` for more information.\n",
					argv[k], argv[0]);
				return -1;
			}
		}
		
		else {
			app.yaml_input << argv[k] << " ";
			in_yaml = true;
		}
	}

	/* Display the help string. */

	if (help || app.yaml_input.IsEmpty())
	{
		fprintf(stderr, "Usage:\n   %s  {directive string}\n"
				"or\n   %s -f filename ...\n"
				"or\n   %s -h | --help\nDisplay a GUI Panel with specified controls\n"
				"\nOptions:\n"
				"   -h, --help\t\tdisplay this help and exit\n"
				"   -f file\t\tread YAML from file (may be repeated)\n",
				argv[0], argv[0], argv[0]);
		return 0;
	}
	
//	printf("Got directives: %s\n", app.yaml_input.String());


	if (!app.yaml_input.IsEmpty()) app.Run();

	return 0;
}
