//******************************************************************************
//
//	File:		WMPanel.cpp
//
//	Description:
//    BWindow subclass (originally for Weaver modules)
//    allowing a certain amount of automatic layout
//    (unrelated to BLayout)
//
// 2011/9/5 -- Copyright 2011 Peter Goodeve
//
//******************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <Application.h>
#include <Window.h>
#include <View.h>
#include <TextView.h>
#include <ScrollBar.h>
#include <ScrollView.h>
#include <TextControl.h>
#include <MessageFilter.h>

#include "WMPanel.h"


struct WMParam {};	// effectively a null pointer, redefined in each module


class WMBGView : public BView {
  public:
	WMBGView(BRect frame) : BView(frame, "base", B_FOLLOW_ALL_SIDES, B_WILL_DRAW){}
	void MouseDown(BPoint point);
};


WMPanel::WMPanel(BRect frame, void *paramblock, const char *title,
	bool toFrontOnClick)
	: BWindow(frame, title, B_TITLED_WINDOW, B_WILL_ACCEPT_FIRST_CLICK),
		param(paramblock), closeMsg(NULL), clickToFront(toFrontOnClick),
		leftMargin(10), topMargin(10), vPad(5), hPad(5)
{
	bgnd = new WMBGView(Bounds());
	BWindow::AddChild(bgnd);
}


WMPanel::WMPanel(BPoint position, void *paramblock, const char *title="Module",
	bool toFrontOnClick=true)
	: BWindow(BRect(position.x, position.y, position.x, position.y),
		title, B_TITLED_WINDOW, B_WILL_ACCEPT_FIRST_CLICK),
		param(paramblock), closeMsg(NULL), clickToFront(toFrontOnClick),
		leftMargin(10), topMargin(10), vPad(5), hPad(5)
{
	bgnd = new WMBGView(Bounds());
	BWindow::AddChild(bgnd);
}


bool WMPanel::QuitRequested()
{
	Hide();
	if (closeMsg) {
		be_app->PostMessage(closeMsg);
		delete closeMsg;
	}
	closeMsg = NULL;
	return false;	// Beware! -- doesn't quit app!
}


void WMPanel::AddChild(BView *child) {
	bgnd->AddChild(child);
	float prefwidth, prefheight;
	BRect childbounds = child->Bounds();
	child->GetPreferredSize(&prefwidth, &prefheight);
	if (prefwidth < childbounds.Width()) prefwidth = childbounds.Width();	// no shrinkage
	if (prefheight < childbounds.Height()) prefheight = childbounds.Height();
	if (prefwidth > childbounds.Width() || prefheight > childbounds.Height())
		child->ResizeTo(prefwidth, prefheight);
	lastRect = child->Frame();
	float panelright =
		lastRect.right + leftMargin > Bounds().Width()?
			lastRect.right + leftMargin : Bounds().Width();
	float panelbottom = 
		lastRect.bottom + topMargin > Bounds().Height()?
			lastRect.bottom + topMargin : Bounds().Height();
	ResizeTo(panelright, panelbottom);
}


BRect WMPanel::NextFrameRight(float width, float height) {
	if (!lastRect.IsValid())
		 lastRect.Set(leftMargin-hPad, topMargin, leftMargin-hPad, topMargin);
	float top = lastRect.top;
	float left = lastRect.right + hPad;
	return BRect(left, top, left+width, top+height);
}


BRect WMPanel::NextFrameBelow(float width, float height) {
	if (!lastRect.IsValid())
		 lastRect.Set(leftMargin, topMargin-vPad, leftMargin, topMargin-vPad);
	float top = lastRect.bottom + vPad;
	float left = lastRect.left;
	return BRect(left, top, left+width, top+height);
}


BRect WMPanel::NextRightAtTop(float width, float height) {
	if (!lastRect.IsValid()) return NextFrameRight(width, height);
	float left = lastRect.right + hPad;
	return BRect(left, topMargin, left+width, topMargin+height);
}


BRect WMPanel::NextBelowAtLeft(float width, float height) {
	if (!lastRect.IsValid()) return NextFrameBelow(width, height);
	float top = lastRect.bottom + vPad;
	return BRect(leftMargin, top, leftMargin+width, top+height);
}


void WMPanel::SetFont(const BFont *font, uint32 properties = B_FONT_ALL) {
	bgnd->SetFont(font, properties);
}
 
 
void WMPanel::GetFont(BFont *font) {
	bgnd->GetFont(font);
}


void WMPanel::SetFontSize(float points) {
	bgnd->SetFontSize(points);
}


void WMBGView::MouseDown(BPoint point) {
	WMPanel *p = (WMPanel *)Window();
	if (p->ToFrontOnClick()) Window()->Activate();
}


BRect WMPanel::SetViewBoundsFromString(BView *view, const char *str,
	float xpad, float ypad) {
	BFont f;
	view->GetFont(&f);
	float fontsize = f.Size();
	font_height fh;
	f.GetHeight(&fh);
	int32 width = (int32)(view->StringWidth(str) + xpad*2 + 0.5);
	int32 height = (int32)(fh.ascent + fh.descent + fh.leading + ypad*2 + 0.5);
	// For now, don't let bounds shrink:
	if (height < view->Bounds().Height())
		height = (int32)view->Bounds().Height();
	if (width < view->Bounds().Width())
		width = (int32)view->Bounds().Width();
	view->ResizeTo(width, height);
}
