//******************************************************************************
//
//	File:		WMPanel.h
//
//	Description:
//    BWindow subclass (originally for Weaver modules)
//    allowing a certain amount of automatic layout
//    (unrelated to BLayout)
//
// 2011/9/9 -- Copyright 2011 Peter Goodeve
//
//******************************************************************************

#ifndef WM_PANEL_H
#define WM_PANEL_H

#include <Window.h>
#include <View.h>
#include <TextView.h>

// Macro WMPARAM must be defined before include!
// Otherwise just use void * pointer

struct WMParam;

class WMPanel : public BWindow {
 public:
	WMPanel(BPoint position, void *paramblock, const char *title="Module",
		bool toFrontOnClick=true);
	WMPanel(BRect frame, void *paramblock, const char *title="Module",
		bool toFrontOnClick=true);
	void AddChild(BView *child);
	WMParam *Param() {return (WMParam *)param;}
	bool ToFrontOnClick() {return clickToFront;}
	BView *Background() {return bgnd;}
	virtual	bool QuitRequested();

	// The following return rects moved over or down by the relevant pad
	// from the boundary of the last added control:	
	BRect NextFrameRight(float width, float height);
	BRect NextFrameBelow(float width, float height);
	BRect NextRightAtTop(float width, float height);
	BRect NextBelowAtLeft(float width, float height);

	// These are the (unpadded) boundaries of the last control placed
	float LastRight() {return lastRect.right;}	
	float LastBottom() {return lastRect.bottom;}	
	float LastTop() {return lastRect.top;}	
	float LastLeft() {return lastRect.left;}
	BRect LastFrame( ){return lastRect;}
	
	void SetPadding(float horiz, float vert) {hPad = horiz; vPad = vert;}
	void SetPadding(BPoint pads) {hPad = pads.x; vPad = pads.y;}
	BPoint Padding() {return BPoint(hPad, vPad);}	// combined for convenience
	void SetLastFrame(BRect frame) {lastRect = frame;}
	void SetLastFrame(float left, float top, float right, float bottom)
		{lastRect = BRect(left, top,right, bottom);}
	BRect SetViewBoundsFromString(BView *view, const char *str,
		float xpad=4, float ypad=4);
	
	// Set the margins before positioning controls
	void SetMargins(float left, float top) {leftMargin=left; topMargin=top;}
	void SetMargins(BPoint margins) {leftMargin=margins.x; topMargin=margins.y;}
	BPoint Margins() {return BPoint(leftMargin, topMargin);}
	BRect MarginRect() {return Bounds().InsetByCopy(leftMargin, topMargin);}
	float LeftMargin(){return leftMargin;}
	float TopMargin(){return topMargin;}

	void SetFont(const BFont *font, uint32 properties = B_FONT_ALL); 
	void GetFont(BFont *font);
	void SetFontSize(float points);

	BMessage *closeMsg;	// public for now

 private:
	BView *bgnd;
	bool clickToFront;
	float topMargin, leftMargin;
	float vPad, hPad;
	BRect lastRect;
	void *param;
};

// Maybe later?:
//class WMView : public BView {
//};

#endif