//******************************************************************************
//
//	File:		WMSlider.cpp
//
//	Description:	Slider for Weaver Modules
//
//		98:10:27
//		99:1:24 -- x86
//		2011/12/20 New thinner WMSlider (LSlider now in WMLSlider.cpp)
//
//******************************************************************************


#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <View.h>
#include <Window.h>
#include <Font.h>
#include <Button.h>
#include <TextView.h>
#include <StringView.h>
#include <Slider.h>
#include <Box.h>

#include "WMSlider.h"


/*------------------------------------------------------------*/

class _WMCntrlSldr : public BSlider
{
  friend class LSLider;
  public:
	_WMCntrlSldr(BRect frame, char *title,
			BStringView *sv,
			long min, long max, long * valoc,
			WMSlider * owner);
	_WMCntrlSldr(BRect frame, char *title,
			BStringView *sv,
			float scaling, float offset,
			int32 places, float * valoc,
			WMSlider * owner);
	void SetValue(int32 v);
	void SetFValue(float v);
	float FValue() {return fvalp? *fvalp : NAN;}
  private:
	BStringView	*vstr;
	long * valp;
	float * fvalp;
	float scaling, offset;
	int32 decimals;
	float rfactor;
	WMSlider * ls;
};


// Note -- 'title' is currently always NULL (Border label used)
_WMCntrlSldr::_WMCntrlSldr(BRect frame, char *title, 
			BStringView *sv, long min, long max, long * valoc,
			WMSlider *owner) :
	BSlider(frame, "slider", title,
			new BMessage('smup'), min, max, B_BLOCK_THUMB,
			B_FOLLOW_ALL_SIDES),
	vstr(sv), valp(valoc), fvalp(NULL), ls(owner)
{
	if (valp) SetValue(*valp);
	SetHashMarks(B_HASH_MARKS_TOP);
	SetHashMarkCount(3);
}


_WMCntrlSldr::_WMCntrlSldr(BRect frame, char *title,
			BStringView *sv,
			float scaling, float offset,
			int32 places, float * valoc,
			WMSlider * owner) :
	BSlider(frame, "slider", title,
			new BMessage('smup'), 0, 1000, B_BLOCK_THUMB,
			B_FOLLOW_ALL_SIDES),
	vstr(sv), fvalp(valoc), valp(NULL),
	scaling(scaling), offset(offset), decimals(places), ls(owner)
{
	if (fvalp) SetFValue(*fvalp);
	SetHashMarks(B_HASH_MARKS_TOP);
	SetHashMarkCount(3);
	rfactor = powf(10.0, decimals);
} 


void _WMCntrlSldr::SetValue(int32 v) 
{
	if (fvalp) SetFValue(floor((v*scaling + offset)*rfactor + 0.5)/rfactor);
	else {
		BSlider::SetValue(v);
		char 	buf[100];
		sprintf(buf, "%d", v);
		vstr->SetText(buf);
		if (valp) *valp = v;
		ls->ValueAct(v);
	}
}


void _WMCntrlSldr::SetFValue(float v) 
{
	BSlider::SetValue((v-offset)/scaling + 0.5);	// round to integer...
	char 	buf[100];
	sprintf(buf, "%.*f", decimals, v);
	vstr->SetText(buf);
	if (fvalp) *fvalp = v;
	ls->ValueAct(v);
}



/*------------------------------------------------------------*/

// Special box that passes mouse up two levels

class _BgndBox : public BBox {
public:
	_BgndBox(BRect frame, const char* name=NULL,
		uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP,
		uint32 flags = B_WILL_DRAW | B_FRAME_EVENTS | B_NAVIGABLE_JUMP,
		border_style border = B_FANCY_BORDER)
		: BBox(frame, name, resizingMode, flags, border) {}
	void MouseDown(BPoint point) {
		Parent()->Parent()->MouseDown(point);
	}
};



/*------------------------------------------------------------*/


#define SLIDER_X_PAD 8
#define SLIDER_Y_PAD 5
#define NUMBER_SPACE 5

WMSlider::WMSlider(BRect view_frame, int32 min, int32 max,
	 int32 * valoc, char * boxname, WMParam *p,
	 uint32 resizingMode)
	: BView(view_frame, "Slider", resizingMode,
			 B_WILL_DRAW), param(p)
{
	BRect view_bound = Bounds();
	font_height fheight;
	char highest[10], lowest[10], *biggest;
	sprintf(highest, "%d", max);
	sprintf(lowest, "%d", min);
	biggest = strlen(highest) > strlen(lowest) ? highest : lowest;
//	printf("biggest=[%s]\n", biggest);
	_BgndBox * b = new _BgndBox(view_bound, "border", B_FOLLOW_ALL_SIDES);
	AddChild(b);
	b->SetLabel(boxname);
	b->GetFontHeight(&fheight);
	float txtspace = boxname ?
		fheight.ascent + fheight.descent : SLIDER_Y_PAD;
	BStringView	* t
		= new BStringView(BRect(0, txtspace, 32, txtspace+18), "value", "",
		B_FOLLOW_TOP_BOTTOM | B_FOLLOW_RIGHT);
	t->ResizeTo(t->StringWidth(biggest) + NUMBER_SPACE, t->Bounds().Height());
	BRect sr(SLIDER_X_PAD, txtspace,
		 view_bound.Width()-SLIDER_X_PAD - t->Bounds().Width(),
		  txtspace+10);
	s = new _WMCntrlSldr(sr, NULL, t, min, max, valoc, this);
	s->ResizeTo(s->Bounds().Width(), s->ThumbFrame().Height()+2*SLIDER_Y_PAD);
	b->AddChild(s);
	t->MoveTo(s->Frame().RightTop());
	b->AddChild(t);
	t->SetAlignment(B_ALIGN_RIGHT);
	b->ResizeTo(b->Bounds().Width(), s->Frame().bottom);
	ResizeTo(b->Bounds().Width(), b->Bounds().Height());
}


void WMSlider::SetValue(int32 val) {
	s->SetValue(val);
}


status_t WMSlider::SetMessage(BMessage *message) {
	return s->SetMessage(message);
}


void WMSlider::SetSnoozeAmount(int32 snoozetime) {
	s->SetSnoozeAmount(snoozetime);
}


int32 WMSlider::Value() {
	return s->Value();
}

/*------------------------------------------------------------*/


WMSlider::WMSlider(BRect view_frame, float min, float max,
	 float * valoc, char * boxname, WMParam *p,
	 uint32 resizingMode)
	: BView(view_frame, "Slider", resizingMode,
			 B_WILL_DRAW), param(p)
{
	BRect view_bound = Bounds();
	font_height fheight;
	char highest[10], lowest[10], *biggest;
	float scaling = (max-min)/1000.0;	// (offset == min)
	printf("scaling = %f offset = %f\n", scaling, min);
	int32 decimals = 0;
	if (scaling < 0.001) decimals = 3;
	else if (scaling < 0.03) decimals = 2;
	else if (scaling < 0.3) decimals = 1;
	sprintf(highest, "%.*f", decimals, max);
	sprintf(lowest,  "%.*f", decimals, min);
	biggest = strlen(highest) > strlen(lowest) ? highest : lowest;
//	printf("biggest=[%s]\n", biggest);
	_BgndBox * b = new _BgndBox(view_bound, "border", B_FOLLOW_ALL_SIDES);
	AddChild(b);
	b->SetLabel(boxname);
	b->GetFontHeight(&fheight);
	float txtspace = boxname ?
		fheight.ascent + fheight.descent : SLIDER_Y_PAD;
	BStringView	* t
		= new BStringView(BRect(0, txtspace, 32, txtspace+18), "value", "",
		B_FOLLOW_TOP_BOTTOM | B_FOLLOW_RIGHT);
	t->ResizeTo(t->StringWidth(biggest) + NUMBER_SPACE, t->Bounds().Height());
	BRect sr(SLIDER_X_PAD, txtspace,
		 view_bound.Width()-SLIDER_X_PAD - t->Bounds().Width(),
		  txtspace+10);
	s = new _WMCntrlSldr(sr, NULL, t, scaling, min, decimals, valoc, this);
	s->ResizeTo(s->Bounds().Width(), s->ThumbFrame().Height()+2*SLIDER_Y_PAD);
	b->AddChild(s);
	t->MoveTo(s->Frame().RightTop());
	b->AddChild(t);
	t->SetAlignment(B_ALIGN_RIGHT);
	b->ResizeTo(b->Bounds().Width(), s->Frame().bottom);
	ResizeTo(b->Bounds().Width(), b->Bounds().Height());
}


void WMSlider::SetFValue(float val) {
	s->SetFValue(val);
}

float WMSlider::FValue() {
	return s->FValue();
}


/*------------------------------------------------------------*/


