//******************************************************************************
//
//	File:		WMSlider.h
//
//	Description:	Sliders for Weaver Modules
//
//		98:10:27
//		99:1:24
//		2011/12/21 WMSlider to replace LSlider
//
//******************************************************************************

#include <Slider.h>

/*------------------------------------------------------------*/

class _WMCntrlSldr; // Private
struct WMParam;	// in client source

/*------------------------------------------------------------*/

class WMSlider : public BView {
  public:
	WMSlider(BRect frame, int32 min, int32 max,
		 int32 * valoc, char * boxname=NULL, WMParam *p=NULL,
		 uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP);
	WMSlider(BRect frame, float min, float max,
		 float * valoc, char * boxname=NULL, WMParam *p=NULL,
		 uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP);
	virtual void SetValue(int32 val);
	virtual void ValueAct(int32 v) {}
	virtual void ValueAct(float v) {}
	virtual void SetFValue(float val);
	int32 Value();
	float FValue();
	status_t SetMessage(BMessage *message);
	void SetSnoozeAmount(int32 snoozetime);	// should be virtual (?)
	WMParam *param;	// convenience -- optional
  protected:
	_WMCntrlSldr * s;
};

/*------------------------------------------------------------*/

// Historically used for several modules
// Avoid for new and rewritten...

class LControlSlider; // Private

class LSlider : public BView {
  public:
	LControlSlider * s;
	LSlider(BRect view_bound, long min, long max,
		 long * valoc, char * boxname=NULL,
		 uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP);
	virtual void SetValue(int32 val);
	int32 Value(void) const;
	virtual void ValueAct(int32 v) {}
	status_t SetMessage(BMessage *message);
};

/*------------------------------------------------------------*/
