
/*

  Project Sayanara
  Copyright (C) 2001 Mark Adams
  Modifications May 2002 by Pete Goodeve
  (Uses stdin (pipe) instead of socket for BeOS/PsiONtrack)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#define _GNU_SOURCE

#include <stdio.h>
#include <getopt.h>

#include <string>

#include <strstream>
#include <fstream>

#include "ssml.h"
#include "vcard.h"

#define DEFAULTPORT 7501

main(int argc, char **argv) {

  int ret;
  int ix;

  int c;
  int digit_optind = 0;

  string format = "VCard";
  string contacts = "C:\\System\\Data\\Contacts.cdb";
  string output = "-";

  int port = DEFAULTPORT;

  bool help=false, verbose=false;

  while (1) {

    struct option options[] = {
      {"help", 0, 0, 'h'},
//      {"input", 1, 0, 'i'},
      {"output", 1, 0, 'o'},
      {"verbose", 0, 0, 'v'},
      {"version", 0, 0, 'V'},
      {0, 0, 0, 0}
    };

    int this_option_optind = optind ? optind : 1;
    int option_index = 0;

    c = getopt_long(argc, argv, "ho:vV",
		    options, &option_index);
    if (c == -1)
      break;

    switch (c) {
    case 'h':
      cerr << "Usage: epoccontacts OPTIONS" << endl;
      cerr << endl;
      cerr << "  Options:" << endl;
      cerr << "    -h, --help          Print this message and exit." << endl;
      cerr << "    -V, --version       Print version and exit." << endl;
      cerr << "    -v, --verbose       Increase verbosity." << endl;
//      cerr << "    -i, --input=<file>  Specify contacts file on EPOC device."
//	   << endl;
      cerr << "    -o, --output=<file> Specify output file." << endl;
      cerr << endl;
      exit(0);

//    case 'i':	// inoperative currently -- stdin (cin) only
//      contacts = optarg;
//      break;

    case 'o':
      output = optarg;
      break;

    case 'v':
      verbose = true;
      break;

    case 'V':
      cerr << "Version " << "alpha 0.0.1" << endl
	   << endl
	   << "Copyright (C) 2001 Mark Adams" << endl 
	   << "ABSOLUTELY NO WARRANTY" << endl
	   << "This is free software, and you are welcome to redistribute it"
	   << endl
	   << "under certain conditions:" << endl
	   << "see http://www.goldenlion.freeserve.co.uk/sayanara" << endl;
      exit(0);

    }

  }

  if (optind < argc) {
    cerr << "Unknown argument: " << argv[optind] << endl;
    exit(1);
  }

  if (format != "VCard" && format != "raw") {
    cerr << "Format '" << format << "' not understood." << endl;
    cerr << "Must be one of: raw VCard" << endl;
    exit(1);
  }

  if (verbose) {
    cerr << "Port: " << port << endl;
    cerr << "Contacts file: " << contacts << endl;
    cerr << "Output: " << output << endl;
    cerr << "Format: " << format << endl;
  }
    
  if (verbose) cerr << "Opening " << output.c_str() << "..." << endl;

  ostream *outputStream;
  if (output == "-")
    outputStream = &cout;
  else {
    outputStream = new ofstream(output.c_str());
    if (outputStream == 0) {
      cerr << "Failed to open output file " << output << endl;
      exit(1);
    }
  }
	

  if (format == "VCard") {
    
    SsmlTokeniser tokeniser(cin);

    ContactsParser parser(tokeniser);

    SsmlContent *content = parser.parse();

    VCardConverter converter(*outputStream);

    converter.convert(content);

  }


  if (verbose) cerr << "All done." << endl;

}

