
/// SSML to VCard format conversion -- EPOC Contacts data ///

/*

  Project Sayanara
  Copyright (C) 2001 Mark Adams
	[Modifications May 2002 -- Pete Goodeve
	-- orphan string pointers changed to actual strings -- slower but cleaner]

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <string>
#include <stdio.h>

#include "ssml.h"
#include "vcard.h"

void VCardConverter::appendAttribute(string &s, string &t) {
	if (!t.empty()) 
		s += t;
	s += ";";
}

void VCardConverter::convertHomeAddress(SsmlStructure *entry) {

	string homeAddress = "";
	vcstring c1 = getContactField(entry, "HomePostOffice");
	vcstring c2 = getContactField(entry, "HomeExtendedAddress");
	vcstring c3 = getContactField(entry, "HomeAddress");
	vcstring c4 = getContactField(entry, "HomeLocality");
	vcstring c5 = getContactField(entry, "HomeRegion");
	vcstring c6 = getContactField(entry, "HomePostCode");
	vcstring c7 = getContactField(entry, "HomeCountry");

	if (c1 || c2 || c3 || c4 || c5 || c6 || c7) {
		appendAttribute(homeAddress, c1);
		appendAttribute(homeAddress, c2);
		appendAttribute(homeAddress, c3);
		appendAttribute(homeAddress, c4);
		appendAttribute(homeAddress, c5);
		appendAttribute(homeAddress, c6);
		if (c7) homeAddress += c7;
		*output << "ADR;HOME:" << homeAddress << "\r\n";
	}

}

void VCardConverter::convertWorkAddress(SsmlStructure *entry) {

	string workAddress = "";
	vcstring c1 = getContactField(entry, "WorkPostOffice");
	vcstring c2 = getContactField(entry, "WorkExtendedAddress");
	vcstring c3 = getContactField(entry, "WorkAddress");
	vcstring c4 = getContactField(entry, "WorkLocality");
	vcstring c5 = getContactField(entry, "WorkRegion");
	vcstring c6 = getContactField(entry, "WorkPostCode");
	vcstring c7 = getContactField(entry, "WorkCountry");

	if (c1 || c2 || c3 || c4 || c5 || c6 || c7) {
		appendAttribute(workAddress, c1);
		appendAttribute(workAddress, c2);
		appendAttribute(workAddress, c3);
		appendAttribute(workAddress, c4);
		appendAttribute(workAddress, c5);
		appendAttribute(workAddress, c6);
		if (c7) workAddress += c7;
		*output << "ADR;WORK:" << workAddress << "\r\n";
	}

}

void VCardConverter::convertContact(SsmlStructure *entry) {

	*output << "BEGIN:VCARD\r\n";

	vcstring field;

	vcstring lastName = getContactField(entry, "FamilyName");
	vcstring firstName = getContactField(entry, "GivenName");
	vcstring middleName = getContactField(entry, "AdditionalName");
	vcstring title = getContactField(entry, "PrefixName");
	vcstring suffix = getContactField(entry, "SuffixName");
	vcstring company = getContactField(entry, "CompanyName");

	string name = "";
	if (lastName || firstName || middleName || title || suffix) {
		appendAttribute(name, lastName);
		appendAttribute(name, firstName);
		appendAttribute(name, middleName);
		appendAttribute(name, title);
		if (suffix) name += suffix;
		*output << "N:" << name << "\r\n";
	}

	if (company)
		*output << "ORG:" << company << "\r\n";

	string fileAs = "";
	if (lastName || firstName || middleName || title || suffix) {
		string sep = "";
		if (title) { fileAs += sep; fileAs += title; sep = " "; }
		if (firstName) { fileAs += sep; fileAs += firstName; sep = " "; }
		if (middleName) { fileAs += sep; fileAs += middleName; sep = " "; }
		if (lastName) { fileAs += sep; fileAs += lastName; sep = " "; }
		if (suffix) { fileAs += sep; fileAs += suffix; sep = " "; }
		*output << "FN:" << fileAs << "\r\n";
	} else if (company) {
		*output << "FN:" << company << "\r\n";
	}

	field = getContactField(entry, "HomePhoneNumber");
	if (field) *output << "TEL;HOME:" << field << "\r\n";

	field = getContactField(entry, "WorkPhoneNumber");
	if (field) *output << "TEL;WORK:" << field << "\r\n";

	// This field doesn't seem to turn up in EPOC R5.
	field = getContactField(entry, "JobTitle");
	if (field) *output << "TITLE:" << field << "\r\n";

	field = getContactField(entry, "HomeEMail");
	if (field) *output << "EMAIL;INTERNET;HOME:" << field << "\r\n";

	field = getContactField(entry, "WorkEMail");
	if (field) *output << "EMAIL;INTERNET;WORK:" << field << "\r\n";

	// Note the order of parameters ^^^ vvv -- this is how Contacts outputs VCF
	// ... probably as the VCard standard says...
	
	field = getContactField(entry, "HomeCellPhoneNumber");
	if (field) *output << "TEL;HOME;CELL:" << field << "\r\n";

	field = getContactField(entry, "HomePagerPhoneNumber");
	if (field) *output << "TEL;HOME;PAGER:" << field << "\r\n";

	field = getContactField(entry, "WorkPagerPhoneNumber");
	if (field) *output << "TEL;WORK;PAGER:" << field << "\r\n";

	field = getContactField(entry, "Url");
	if (field) *output << "URL:" << field << "\r\n";

	field = getContactField(entry, "Note");
	if (field) *output << "NOTE;QUOTED-PRINTABLE:" << field << "\r\n";

	convertHomeAddress(entry);
	convertWorkAddress(entry);

	*output << "END:VCARD\r\n";
	*output << "\r\n";

}

void VCardConverter::convert(SsmlContent *document) {

	// Top level must be a structure containing a contacts
	SsmlStructure *x = (SsmlStructure *) document;
	if (!x) {
		fprintf(stderr, "No document!\n");
		return;
	}
	SsmlStructure *contacts = (SsmlStructure *) *(x->children.begin());
	if (!contacts) {
		fprintf(stderr, "No contacts!\n");
		return;
	}
		
	list<SsmlContent *>::iterator it = contacts->children.begin();
		
	while (it != contacts->children.end()) {
		convertContact((SsmlStructure *)(*it));
		it++;
	}

}

// This version returns a string (not a pointer) -- slower but safer re leaks
vcstring VCardConverter::getContactField(SsmlStructure *contact, 
							string type) {

	list<SsmlContent *>::iterator it = contact->children.begin();
	vcstring ret;
		
	while (it != contact->children.end()) {
		SsmlStructure *field = (SsmlStructure *)(*it);
		// These strings are NOT created by these calls (and should not be deleted)
		string *t = field->childStringContent("type");
		string *v = field->childStringContent("textvalue");
		if (t != 0 && *t == type) {
			ret = *v;
			// Convert newline characters to =0A
			int posn;
			while ((posn = ret.find("\n", 1)) >= 0) {
				ret.replace(posn, 1, "=0A", 3);
			}
			// might as well do return chars too
			while ((posn = ret.find("\r", 1)) >= 0) {
				ret.replace(posn, 1, "=0D", 3);
			}
		}
		it++;
	}
	return ret;
}

