
/*

  Project Sayanara
  Copyright (C) 2001 Mark Adams

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <string>

// Convenience class so that we can test for empty quickly
class vcstring : public string {
	public:
	vcstring(const char *s) : string(s) {};
	vcstring(string &s) : string(s) {};
	vcstring() : string() {};
	operator bool() {return !this->empty();}
};


class VCardConverter {
  void error(string &s) {
    cerr << "VCardConverter error: " << s << endl;
    exit(1);
  };
  void error(char *x) { string e(x); error(e); }
  void convertContact(SsmlStructure *contact);
  vcstring getContactField(SsmlStructure *contact, string type);
  void appendAttribute(string &s, string &t);
  void convertHomeAddress(SsmlStructure *entry);
  void convertWorkAddress(SsmlStructure *entry);
  ostream *output;
public:
  void convert(SsmlContent *document);
  VCardConverter(ostream &output) {
    this->output = &output;
  }
  ~VCardConverter() {*output << flush; }	// needed for BeOS
};
