// Test of Handler Chain

#include "psionconn.h"

class TestApplication : public BApplication 
{
public:
	TestApplication() : BApplication("application/x-Test-MessengerTest") {
	}
	
	void ReadyToRun(void) {
		printf("Let's roll...!\n");
		PsionConnector cnct("SYS$RPCS");
		BMessenger msngr(SERVERSIG);
		if (cnct.connected()) {
			int8 infopkt[] = {8};	// query owner info

			int len = cnct.transaction(infopkt, sizeof(infopkt));
			int8 *resp_data = (int8 *)cnct.response();
			if (len <= 0 || resp_data[0] != 0) {	//  don'tseem to be in touch
				fprintf(stderr, "RPCS Owner Info failure!\n");
				PostMessage(B_QUIT_REQUESTED);
				return;
			}
			printf("Owner Info: %d bytes of data status %x\n", len, resp_data[0]);
			for (int i=1; i < len; i++) 
				if (resp_data[i] < 0x20)  // convert non-printing
					resp_data[i] = '\n';	// to newline
			printf("----------->\n");
			printf("[%.*s]\n", len-1, resp_data+1);
			printf("\n");

			int8 querypkt[] = {02, 'C'};	// query drive
			len = cnct.transaction(querypkt, sizeof(querypkt));
			char *resp_strings = (char *)cnct.response();
			if (len <= 0) {	//  don'tseem to be in touch
				fprintf(stderr, "RPCS Drive Info failure!\n");
				PostMessage(B_QUIT_REQUESTED);
				return;
			}
			printf("Active Programs: %d bytes of data\n", len);
			char *cp = resp_strings;
			char *lim = resp_strings + len;
			printf("----------->\n");
			while (cp < lim) {
				printf("%s ", cp);
				cp += strlen(cp)+1;
				printf("%s\n", cp);
				cp += strlen(cp)+1;
			}
			printf("\n");
		}

		PostMessage(B_QUIT_REQUESTED);
	}
};



int main(void)
{	
	TestApplication	myApplication;
	myApplication.Run();
	return(0);
}

