/// Class to communicate with (non-resident) Servers on a Psion via PsiONtrack ///
// Copyright Pete Goodeve 2002
// This is free software, and may be distributed without restraint.
// Absolutely NO warranty is expressed or implied.

// for details, see psionconn.h //

#include <stdio.h>
#include <unistd.h>
#include <Application.h>

#include "psionconn.h"

bool PsionConnector::connect(const char *srvname) {
	disconnect();	// in case...
	BMessenger cmsngr(SERVERSIG);
	BMessage reply;
	if (cmsngr.IsValid()) {
		cmsngr.SendMessage('link', &reply);
//		printf("Reply contains %.4s\n", &reply.what);
	}
	if (reply.FindMessenger("messenger", &msngr) == B_OK)
		fprintf(stderr, "Connected to PsiONtrack...\n");
	else {
		fprintf(stderr, "Couldn't connect...\n");
		return false;
	}
	srvrconn.what = 'conn';
	srvrconn.AddString("server", srvname);	// the server we want to talk to
	msngr.SendMessage(&srvrconn, &srvrconn);	// reply back into same message
//	printf("srvrconn returned with %.4s\n", &srvrconn.what);
	if (srvrconn.what == 'conn') {
		fprintf(stderr, "Connected to Server %s\n", srvname);
		return true; 	// would be 'eror' on failure
	}
	else {
		fprintf(stderr, "Couldn't connect to Server %s\n", srvname);
		return false;
	}
}

void PsionConnector::disconnect() {
	if (srvrconn.IsEmpty()) return;
	srvrconn.what = 'disc';
	msngr.SendMessage(&srvrconn);
	srvrconn.MakeEmpty();
}

ssize_t PsionConnector::transaction(void *cmd_data, size_t cmd_len) {
	BMessage cmd(srvrconn);
	cmd.what = 'pcmd';
	cmd.AddData("command", B_RAW_TYPE, cmd_data, cmd_len);
	msngr.SendMessage(&cmd, &respmsg);
	if (respmsg.FindData("data", B_RAW_TYPE, &resp_data, &resp_len) == B_OK) {
		return resp_len;
	}
	else {
		resp_data = NULL;
		resp_len = B_BAD_VALUE;
		return B_BAD_VALUE;	// or something...
	}
}


///////////////////////////////////////////////////////////////////
