/// Class to communicate with (non-resident) Servers on a Psion via PsiONtrack ///
// Copyright Pete Goodeve 2002
// This is free software, and may be distributed without restraint.
// Absolutely NO warranty is expressed or implied.

#include <stdio.h>
#include <unistd.h>
#include <Application.h>

// Create an instance of this class, passing the desired Server name
// (without any trailing ".*"). PsiONtrack must already be running and
// connected to the Psion.  This should open a link to the server
// through which commands can be sent -- and responses received --
// using the transaction(..) method.
//
// The command packet is sent verbatim, and must be structured
// appropriately for that server. (Watch out for string-lengths 
// -- some servers want them *without* a null terminator, length
// determined by the length of the packet! Others might *require*
// the terminator...)
//
// The response is also exactly as received from the server. It will
// have to be decoded appropriately.  A pointer to it is available until
// the next transaction though the response() method, and its length
// (in bytes) will be returned by responseSize() (also by transaction(...)
// itself).  If there is an error, these latter will return B_BAD_VALUE,
// and the pointer will be NULL.
//
// The class takes care of all channel management.  The channel will
// be closed when the instance is deleted.

class PsionConnector {
	BMessenger msngr;
	BMessage srvrconn, respmsg;
	const void *resp_data;
	ssize_t resp_len;
  public:
	PsionConnector(const char *srvname) {connect(srvname);}
	~PsionConnector() {disconnect();}
	bool connect(const char *srvname);
	void disconnect();
	bool connected() {return msngr.IsValid();}
	ssize_t transaction(void *cmd_data, size_t cmd_len);
	const void * response() {return resp_data;}
	ssize_t responseSize() {return resp_len;}
};

#define SERVERSIG "application/x-vnd.PsiONtrack"

///////////////////////////////////////////////////////////////////
